float4x4 mWorldViewProj;
float4x4 mWorldViewInv;
float gNumSpikesX;
float gNumSpikesY;
float gSpikeSize;
float gPS;
float gPT;

struct VS_OUTPUT
{
    float4 Position		: POSITION;   // vertex position 
    float2 UV			: TEXCOORD0;
    float3 Normal		: TEXCOORD1;
};

#define PI 3.14159265354

VS_OUTPUT main( in float2 vPosition : POSITION )
{
	VS_OUTPUT Output;
	
	Output.UV = (vPosition + 1.0f) * 0.5f;
	
	float x = vPosition.x*PI;
	float y = vPosition.y*PI*0.5f;
	
	float s = gNumSpikesX;
	float t = gNumSpikesY;
	float p = gSpikeSize;
	
	float radius = 1.0f + (sin(x*s) + sin(y*t))*p;
	
	float4 pos = float4(cos(x)*cos(y)*radius, sin(x)*cos(y)*radius, sin(y)*radius, 1.0f);
	
    Output.Position = mul(pos, mWorldViewProj);
    
    //x-component of gradient
    //d(cos(x)*cos(y)*(1.0 + (sin(x*s) + sin(y*t))*p))/dx
    float ux = gPS * cos(x) * cos(s*x) * cos(y) - cos(y) * sin(x) * radius;
    
    //d(sin(x)*cos(y)*(1.0 + (sin(x*s) + sin(y*t))*p))/dx
    float uy = gPS * cos(s*x) * cos(y) * sin(x) + cos(x) * cos(y) * radius;
    
    //y-component of gradient
    //d(sin(y)*(1.0 + (sin(x*s) + sin(y*t))*p))/dx
    float uz = gPS * cos(s*x) * sin(y);
    
    //d(cos(x)*cos(y)*(1.0 + (sin(x*s) + sin(y*t))*p))/dy
    float vx = gPT * cos(x) * cos(y) * cos(t*y) - cos(x) * sin(y) * radius;
    
    //d(sin(x)*cos(y)*(1.0 + (sin(x*s) + sin(y*t))*p))/dy
    float vy = gPT * cos(y) *	cos(t*y) * sin(x) - sin(x) * sin(y) * radius;
    
    //d(sin(y)*(1.0 + (sin(x*s) + sin(y*t))*p))/dy
    float vz = gPT * cos(t*y) * sin(y) + cos(y) * radius;
    
    float3 u = float3(ux, uy, uz);
    float3 v = float3(vx, vy, vz);
    float3 normal = cross(u,v);
    normal = mul(mWorldViewInv, normal);
    Output.Normal = normal;
    
    return Output;
}